/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	UseComponent.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFeature.h"
#include  "CApplication.h"

//	perform operation to a create tool and return the newly created tool

HRESULT UseComponent(IDesignInstance *pComponent, long materialStatus, VARIANT_BOOL bHideComponent, CString featureName, ITool **pUseComponent)
{

	START_METHOD("UseComponent")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL; 
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	IDesignInstance *designInstance = NULL;
	// hide the component if the value of bHideComponent is true
	if(bHideComponent)
	{
		designInstance = CAST(IDesignInstance, pComponent);

		status = designInstance->SetHidden(TRUE);
		CHECK_RETURN_STATUS(status)

		status = activeGraphicDoc->ClearSelection();
		CHECK_RETURN_STATUS(status)
	}

	// perform operation to a create tool
	ITool *component = NULL;
	status = (GetCLASS(Tool))->CreateTool(pDesign, pComponent, materialStatus, &component);
	CHECK_RETURN_STATUS(status)

	IOperation *operation = CAST(IOperation, component);

	status = operation->SetName(featureName.AllocSysString());
	CHECK_RETURN_STATUS(status)
	*pUseComponent = component;

	END_METHOD("UseComponent")
}
